/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_bustri ( result, tridata,
        data, enabledt, enabletr) ;

  parameter lpm_type = "lpm_bustri" ;
  parameter lpm_width  = 1 ;
  parameter polar_data     = "NORMAL" ;
  parameter polar_enabletr = "NORMAL" ;
  parameter polar_enabledt = "NORMAL" ;
  parameter polar_result   = "NORMAL" ;
  parameter polar_tridata  = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  input  enabletr ;
  input  enabledt ;
  output [lpm_width-1:0] result;
  inout  [lpm_width-1:0] tridata ;


  // inernal reg 
  reg   [lpm_width-1:0] tmp_result ;
  reg   [lpm_width-1:0] tmp_tridata ;
  reg   [lpm_width-1:0] pdata ;
  reg   [lpm_width-1:0] ptridata ;
  reg   penabletr ;
  reg   penabledt ;
  reg   [lpm_width-1:0] HiZ ;
  integer i ;

  pulldown P1 ( enabledt) ;
  pulldown P2 ( enabletr) ;

  initial
  begin
    for(i=0; i < lpm_width; i=i+1)
      begin
        HiZ[i] = 1'bz ;
      end
  end

  always @(enabledt)
  begin
	penabledt <= #1 (polar_enabledt == "INVERT")?~enabledt:enabledt;
  end
	
  always @(enabletr)
  begin
	penabletr <= #1 (polar_enabletr == "INVERT")?~enabletr:enabletr;
  end
	
  always @(data or tridata)
  begin
	pdata     <= #1 (polar_data == "INVERT")?~data:data;
	ptridata  <= #1 (polar_tridata == "INVERT")?~tridata:tridata;
  end
	
  always @( penabledt or pdata or penabletr or ptridata)
    begin 
      tmp_tridata = penabledt? data: (penabletr? ptridata: HiZ) ;
      tmp_result = penabletr? tmp_tridata: HiZ ;
    end

  assign result = (polar_result == "INVERT")?~tmp_result:tmp_result ;
  assign tridata = (polar_tridata == "INVERT")?~tmp_tridata:tmp_tridata ;

endmodule // lpm_bustri
`ifdef SYNTH
`else
`endcelldefine
`endif
 
